#include <QtGui>

 #include "singleTableInfo.h"

 #define MESSAGE \
     singleTableInfo::tr("<p>Message boxes have a caption, a text, " \
                "and any number of buttons, each with standard or custom texts." \
                "<p>Click a button to close the message box. Pressing the Esc button " \
                "will activate the detected escape button (if any).")

 singleTableInfo::singleTableInfo(QWidget *parent)
     : QDialog(parent)
 {
	rowCurrentCount = 0; 
	
	QImage tableIcon(tr("images/Table.png"));
	tableIconLabel = new QLabel;
	tableIconLabel->setPixmap(QPixmap::fromImage(tableIcon));
	currentTablecontents = new QLabel(tr("̺ ̸ :"));
	currentTableLabel = new QLabel("");	
	
	tablePage	= new NewTablePage(this);
	createData();
	
	applyBtn	= new QPushButton(tr("Ȯ"));
	cancelBtn	= new QPushButton(tr(""));

	connect(applyBtn, SIGNAL(clicked()), this, SLOT(ClickApply()));
	connect(cancelBtn, SIGNAL(clicked()), this, SLOT(ClickCancel()));

	currentTablecontents->setFixedSize(80,30);
	currentTableLabel->setFixedSize(150,30);
	
	QGridLayout * TableNameLayout = new QGridLayout;	 
	TableNameLayout->addWidget(tableIconLabel,0,0);
	TableNameLayout->addWidget(currentTablecontents,0,1);
	TableNameLayout->addWidget(currentTableLabel,0,2);
	TableNameLayout->setAlignment(Qt::AlignLeft);

	QHBoxLayout * BtnLayout = new QHBoxLayout;
	BtnLayout->addWidget(applyBtn);
	BtnLayout->addWidget(cancelBtn);
	BtnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);

    QVBoxLayout *TableLayout = new QVBoxLayout;
	TableLayout->addLayout(TableNameLayout);
    TableLayout->addWidget(tablePage);
	TableLayout->addLayout(BtnLayout);
    setLayout(TableLayout);
	
	setGeometry(0,0,800,400);
	setWindowTitle(tr("̺ Ӽ ̾α"));
 }
 
 singleTableInfo::singleTableInfo(QString tableName, QWidget *parent) : QDialog(parent)
 {
	 rowCurrentCount = 0; 
	 QImage tableIcon(tr("images/Table.png"));
	 tableIconLabel = new QLabel;
	 tableIconLabel->setPixmap(QPixmap::fromImage(tableIcon));
	 currentTablecontents = new QLabel(tr("̺ ̸ :"));
	 currentTableLabel = new QLabel("");

	 tablePage	= new NewTablePage(this);
	 this->selectTableName = tableName;

	 createData();
	 
	 applyBtn	= new QPushButton(tr("Ȯ"));
	 cancelBtn	= new QPushButton(tr(""));
	 
	 connect(applyBtn, SIGNAL(clicked()), this, SLOT(ClickApply()));
	 connect(cancelBtn, SIGNAL(clicked()), this, SLOT(ClickCancel()));
	 
	 currentTablecontents->setFixedSize(80,30);
	 currentTableLabel->setFixedSize(150,30);
	
	 QGridLayout * TableNameLayout = new QGridLayout;	 
	 TableNameLayout->addWidget(tableIconLabel,0,0);
	 TableNameLayout->addWidget(currentTablecontents,0,1);
	 TableNameLayout->addWidget(currentTableLabel,0,2);
	 TableNameLayout->setAlignment(Qt::AlignLeft);

	 QHBoxLayout * BtnLayout = new QHBoxLayout;
	 BtnLayout->addWidget(applyBtn);
	 BtnLayout->addWidget(cancelBtn);
	 BtnLayout->setAlignment(Qt::AlignBottom | Qt::AlignRight);
	 
	 QVBoxLayout *TableLayout = new QVBoxLayout;
	 TableLayout->addLayout(TableNameLayout);
	 TableLayout->addWidget(tablePage);
	 TableLayout->addLayout(BtnLayout);
	 setLayout(TableLayout);
	 
	 setGeometry(0,0,800,400);
	 setWindowTitle(tr("̺ Ӽ ̾α"));
 }

 void singleTableInfo::execSql()
{
	int fieldCount = fieldInfo.count();
	qDebug() <<"tableCount:::"<< fieldCount;
	tableQueryMaker.TableName(selectTableName);
	QString fieldQuery = tr("");
	createTableQuery = QSqlQuery(tableQueryMaker.clearTable());	
	qDebug() << tableQueryMaker.clearTable();
	createTableQuery.exec();
	for(int cnt=0; cnt<fieldCount;cnt++)
	{									
		
		
		QString temp = tableQueryMaker.createTable();
		qDebug() << "tableName"<<selectTableName;
		qDebug() << temp;
		createTableQuery = QSqlQuery(temp);
		createTableQuery.exec();
		
		bool primaryKey = fieldInfo[cnt]->getPrimaryKey();
		qDebug() << primaryKey;		
		QString fieldName = fieldInfo[cnt]->getFieldName();
		qDebug() << fieldName;
		QString fieldDataType = fieldInfo[cnt]->getFieldDataType();
		qDebug() << fieldDataType;
		QString fieldLength = fieldInfo[cnt]->getFieldLength();
		qDebug() << fieldLength;
		bool null = fieldInfo[cnt]->getNotNull();
		qDebug() << null;
		QString defaultValue = fieldInfo[cnt]->getDefaultVaule();
		qDebug() << defaultValue;
		QString comment = fieldInfo[cnt]->getComment();
		qDebug() << comment;
		fieldQuery  += tableQueryMaker.createField(fieldCount, cnt, fieldName, fieldDataType, fieldLength, null);
		
		qDebug()<<fieldQuery;
		createTableQuery = QSqlQuery(fieldQuery);
		createTableQuery.exec();
		fieldQuery.clear();
			
		tableQueryMaker.PrimaryFields(primaryKey,fieldName);
	}
		if(tableQueryMaker.primaryFieldCount() > 0)
		{
			qDebug()<<tableQueryMaker.createPrimaryField();
			createTableQuery = QSqlQuery(tableQueryMaker.createPrimaryField());	
			createTableQuery.exec();
		}
		qDebug()<<tableQueryMaker.endMakeTable();
	
}


 void singleTableInfo::ClickApply()
 {
	QMessageBox::StandardButton closeMessage;
     closeMessage = QMessageBox::warning(this, tr("ϱ"),
         tr("  մϴ.\n"
            " Ͻðڽϱ?"),
         QMessageBox::No | QMessageBox::Yes);

     if (closeMessage == QMessageBox::Yes)
	 {
		 /*if(fieldInfo.count()<0)
		 {
			filedProperty* fieldItem = new filedProperty();
			fieldInfo << fieldItem;
		 }*/
		
		int filedRowCount = tablePage->TableProperty->rowCount();
		//int filedColumnCount = tablePage->TableProperty->columnCount();
		
		bool fPrimaryKey;			
		QString	fFieldName;		
		QString	fFieldDataType;		
		QString fLength;
		int fNotNull;			
		QString fDefaultVaule;		
		QString fComment;

		for(int cnt=0;cnt<filedRowCount;cnt++)
			{
				if(!tablePage->TableProperty->item(cnt,0))
					fPrimaryKey = false;
				else
					fPrimaryKey = true;
			
				qDebug()<<fPrimaryKey ;			
				fFieldName =  tablePage->TableProperty->item(cnt,1)->text();	
				qDebug()<<fFieldName ; 
									
				if(fFieldName == tr(""))
				continue;

				fFieldDataType = ((QComboBox*)(tablePage->TableProperty->cellWidget(cnt,2)))->currentText();
				qDebug()<<fFieldDataType ; 
				fLength = tablePage->TableProperty->item(cnt,3)->text();
				qDebug()<<fLength ; 
				fNotNull = ((QCheckBox*)(tablePage->TableProperty->cellWidget(cnt,4)))->checkState();
				qDebug()<<fNotNull ; 
				fDefaultVaule = tablePage->TableProperty->item(cnt,5)->text();	
				qDebug()<<fDefaultVaule ; 
				fComment = tablePage->TableProperty->item(cnt,6)->text();
				qDebug()<<fComment ;

				filedProperty* buffer = new filedProperty(fPrimaryKey,fFieldName,fFieldDataType,fLength,fNotNull,fDefaultVaule,fComment);
				fieldInfo << buffer;
				qDebug()<<"@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" ; 
			}

		 execSql();
		 accept ();

	 }
 }

  void singleTableInfo::ClickCancel()
 {
	       reject();
 }

 void singleTableInfo::createData()
 {
	qDebug() << tableQueryMaker.tableNames();

	 int column = 0;
	//selectTableName.clear();
	//selectTableName = tr("NewTable");
	//tableRelaitonPage->AddComboBoxData(selectTableName , 0);
	qDebug() << tableQueryMaker.columnNames(selectTableName);
	createTableQuery = QSqlQuery( tableQueryMaker.columnNames(selectTableName));

	//tablePage->reSizedTable(15, 7);
	currentTableLabel->setText(selectTableName);
	
		while(createTableQuery.next())
		{	for(int cnt=0;cnt<5;cnt++)
	 {
			if(cnt == 0)
			{
				int inx = 1;
				qDebug() << createTableQuery.value(cnt).toString();	
				QString data = createTableQuery.value(cnt).toString();
				qDebug()<<"inx:" << inx <<"column:" <<column << data <<"cnt:" << cnt;
				tablePage->AddTableData(column, inx, data);
			}
			else if(cnt == 1)
			{
				
				QString dataType;
				QString length;
				dataType.clear();
				length.clear();
				qDebug() << createTableQuery.value(cnt).toString();	
				QString data = createTableQuery.value(cnt).toString();
				
				//int n=0;
				int i=0;
				int state = 0;

				while( i< data.count() && state < 2 ){
					if( state == 0 ){
						if( data[i] != '(' ){
							dataType += data[i];
						}
					}
					else if( state == 1){
						if( data[i] != ')' ){
							length += data[i];
						}
					}
					if( data[i] == '(' ){
						state++;
					}
					else if ( data[i] == ')' )
					{
						state++;
					}
					i++;
				}

				qDebug() << length;
				qDebug() << dataType;
		
				int inx = 2;
				tablePage->AddTableData(column, inx, dataType);
				inx = 3;
				tablePage->AddTableData(column, inx, length);
				
			}
			else if(cnt == 2)
			{
				int inx = 4;
				qDebug() << createTableQuery.value(cnt).toString();	
				QString data = createTableQuery.value(cnt).toString();
				tablePage->AddTableData(column, inx, data);
			}
			else if(cnt == 3)
			{
				int inx = 0;
				qDebug() << createTableQuery.value(cnt).toString();	
				QString data = createTableQuery.value(cnt).toString();
				tablePage->AddTableData(column, inx, data);
			}
			else if(cnt == 4)
			{
				int inx = 5;
				qDebug() << createTableQuery.value(cnt).toString();	
				QString data = createTableQuery.value(cnt).toString();
				tablePage->AddTableData(column, inx, data);
				inx =6;
				tablePage->AddTableData(column, inx, data);
			}
		}	
		column++;
	 }
 }
